local function interactions_for_spec(spec, part)
  local grid = {}
  for i,v in pairs(spec) do
    grid_store(grid, Vector.new(i - 1, 0), part)
    if v == 1 then
      grid_store(grid, Vector.new(i - 1, 1), part)
    end
  end
  return fully_connected_object_interactions(grid)
end
function add_specs(spec1, spec2)
  local ret = {}
  local carry = 0
  for i = 8,1,-1 do
    local total = spec1[i] + spec2[i] + carry
    ret[i] = total % 2
    if total >= 2 then
      carry = 1
    else
      carry = 0
    end
  end
  return ret
end
location.std.generators[1].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct)[1], 1)
end
location.std.generators[2].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct)[2], 2)
end
location.std.checkers[1].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct)[1], 1)
end
location.std.checkers[2].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct)[2], 2)
end
location.std.checkers[3].dynamic = function(ct)
  return interactions_for_spec(add_specs(get_spec(ct)[1], get_spec(ct)[2]), 3)
end

local specifications =
{{
	{0, 0, 0, 0, 1, 1, 1, 0},
	{1, 0, 0, 0, 0, 0, 1, 1}
},
{
	{0, 0, 1, 1, 0, 0, 0, 1},
	{1, 0, 0, 0, 1, 0, 0, 1}
},
{
	{1, 0, 1, 1, 1, 0, 1, 0},
	{1, 1, 0, 1, 1, 0, 1, 0}
},
{
	{0, 0, 1, 1, 1, 1, 0, 0},
	{1, 0, 1, 1, 1, 1, 0, 1}
},
{
	{0, 0, 0, 1, 0, 1, 0, 1},
	{1, 1, 1, 0, 0, 0, 1, 1}
},
{
	{0, 0, 0, 0, 0, 0, 0, 1},
	{0, 0, 1, 0, 0, 0, 0, 0}
},
{
	{0, 1, 0, 0, 0, 0, 1, 1},
	{0, 0, 1, 0, 1, 1, 1, 0}
},
{
	{0, 1, 0, 1, 0, 1, 0, 0},
	{1, 0, 1, 0, 1, 0, 0, 0}
},
{
	{1, 1, 0, 0, 0, 0, 1, 1},
	{0, 0, 0, 1, 0, 0, 1, 0}
},
{
	{1, 1, 0, 1, 0, 1, 0, 0},
	{1, 0, 0, 1, 0, 1, 0, 0}
},
{
	{0, 1, 1, 0, 1, 1, 0, 0},
	{0, 1, 0, 0, 1, 1, 0, 1}
},
{
	{1, 0, 0, 1, 1, 0, 1, 1},
	{1, 1, 0, 1, 1, 0, 0, 1}
},
{
	{0, 1, 0, 0, 0, 0, 1, 1},
	{1, 1, 0, 0, 0, 0, 0, 0}
},
{
	{0, 1, 0, 0, 1, 0, 0, 0},
	{1, 0, 0, 1, 0, 0, 0, 0}
},
{
	{1, 1, 1, 0, 1, 0, 1, 0},
	{1, 0, 0, 1, 1, 1, 0, 1}
},
{
	{0, 1, 0, 0, 0, 1, 0, 1},
	{0, 1, 0, 0, 1, 0, 0, 0}
},
{
	{0, 1, 1, 1, 1, 0, 0, 1},
	{0, 0, 0, 1, 1, 1, 1, 0}
},
{
	{1, 0, 0, 0, 1, 1, 1, 0},
	{1, 0, 1, 0, 1, 0, 1, 0}
},
{
	{1, 1, 0, 1, 1, 0, 1, 1},
	{0, 1, 1, 0, 0, 0, 1, 1}
},
{
	{1, 0, 0, 1, 1, 1, 0, 0},
	{0, 1, 1, 0, 0, 0, 0, 1}
},
{
	{1, 1, 1, 0, 1, 1, 0, 1},
	{1, 0, 1, 0, 0, 1, 1, 1}
},
{
	{0, 0, 1, 0, 0, 1, 1, 1},
	{1, 1, 0, 0, 1, 1, 0, 0}
},
{
	{1, 1, 0, 0, 0, 1, 1, 0},
	{1, 0, 0, 0, 1, 0, 0, 1}
},
{
	{1, 0, 1, 0, 0, 1, 1, 0},
	{1, 0, 1, 1, 0, 0, 0, 0}
},
{
	{0, 0, 1, 1, 0, 1, 0, 0},
	{1, 1, 0, 1, 0, 0, 0, 0}
},
{
	{1, 0, 0, 0, 1, 1, 1, 1},
	{1, 1, 1, 1, 0, 1, 1, 1}
},
{
	{1, 0, 0, 1, 1, 1, 0, 0},
	{1, 1, 0, 0, 1, 1, 0, 1}
},
{
	{1, 0, 0, 0, 1, 1, 0, 0},
	{1, 0, 1, 1, 1, 1, 0, 1}
},
{
	{0, 0, 1, 0, 1, 1, 0, 0},
	{1, 1, 0, 1, 1, 1, 0, 0}
},
{
	{0, 1, 0, 0, 0, 1, 1, 1},
	{1, 0, 1, 0, 1, 1, 0, 0}
},
{
	{1, 0, 0, 0, 0, 0, 0, 1},
	{0, 1, 0, 1, 1, 0, 0, 0}
},
{
	{1, 0, 0, 0, 1, 1, 0, 0},
	{1, 1, 1, 0, 0, 0, 0, 0}
},
{
	{0, 0, 1, 0, 1, 1, 1, 0},
	{0, 0, 0, 1, 0, 1, 1, 0}
},
{
	{1, 0, 0, 1, 0, 1, 1, 0},
	{0, 1, 0, 0, 0, 0, 1, 1}
},
{
	{0, 1, 0, 0, 0, 0, 0, 0},
	{0, 1, 1, 0, 0, 1, 0, 1}
},
{
	{1, 0, 1, 1, 0, 0, 0, 1},
	{1, 0, 0, 1, 1, 1, 1, 1}
},
{
	{0, 0, 0, 1, 1, 0, 0, 1},
	{1, 0, 1, 1, 1, 0, 1, 0}
},
{
	{1, 1, 0, 0, 1, 1, 1, 1},
	{1, 1, 0, 0, 0, 0, 1, 1}
},
{
	{1, 1, 0, 0, 0, 1, 1, 0},
	{1, 1, 0, 1, 0, 1, 1, 1}
},
{
	{0, 1, 0, 0, 0, 0, 0, 0},
	{1, 1, 0, 1, 0, 1, 1, 0}
},
{
	{1, 0, 1, 0, 1, 0, 0, 1},
	{0, 1, 1, 0, 1, 1, 0, 0}
},
{
	{1, 0, 0, 1, 1, 0, 1, 0},
	{0, 1, 0, 1, 0, 1, 0, 1}
},
{
	{0, 0, 1, 1, 1, 0, 0, 0},
	{0, 0, 0, 0, 1, 0, 1, 0}
},
{
	{0, 1, 1, 0, 1, 0, 0, 1},
	{0, 1, 1, 0, 1, 1, 1, 1}
},
{
	{1, 1, 1, 1, 1, 0, 0, 0},
	{0, 0, 1, 1, 1, 0, 1, 0}
},
{
	{1, 0, 0, 1, 1, 0, 1, 1},
	{1, 1, 0, 0, 1, 0, 0, 0}
},
{
	{1, 1, 0, 0, 0, 0, 1, 0},
	{1, 0, 1, 1, 1, 1, 0, 0}
},
{
	{1, 1, 1, 0, 0, 1, 1, 0},
	{1, 1, 0, 0, 0, 1, 0, 1}
},
{
	{1, 0, 0, 1, 0, 1, 0, 0},
	{0, 0, 1, 0, 0, 1, 0, 0}
},
{
	{1, 1, 1, 0, 0, 1, 0, 0},
	{1, 1, 1, 1, 0, 0, 0, 1}
},
{
	{0, 0, 1, 0, 1, 0, 0, 1},
	{0, 0, 0, 1, 0, 1, 1, 0}
},
{
	{0, 1, 1, 1, 0, 0, 1, 1},
	{1, 1, 0, 0, 1, 1, 1, 1}
},
{
	{0, 1, 1, 0, 0, 1, 0, 1},
	{0, 1, 1, 0, 1, 0, 1, 1}
},
{
	{1, 1, 0, 1, 1, 0, 0, 0},
	{0, 0, 1, 0, 0, 0, 1, 1}
},
{
	{1, 1, 0, 1, 0, 0, 1, 1},
	{1, 1, 0, 1, 1, 1, 0, 1}
},
{
	{1, 1, 0, 1, 1, 1, 0, 1},
	{0, 0, 1, 1, 0, 1, 1, 1}
},
{
	{0, 0, 0, 1, 0, 0, 0, 1},
	{0, 1, 0, 1, 1, 1, 1, 0}
},
{
	{0, 0, 1, 0, 0, 0, 1, 0},
	{0, 1, 0, 1, 0, 1, 1, 0}
},
{
	{0, 1, 0, 1, 1, 0, 1, 1},
	{1, 1, 0, 1, 0, 1, 0, 1}
},
{
	{0, 1, 1, 0, 1, 0, 0, 0},
	{1, 1, 1, 1, 0, 1, 0, 1}
},
{
	{1, 1, 1, 0, 1, 1, 1, 0},
	{1, 0, 1, 0, 1, 1, 0, 0}
},
{
	{0, 1, 1, 1, 1, 0, 0, 1},
	{1, 0, 0, 1, 0, 0, 0, 1}
},
{
	{0, 0, 0, 1, 0, 1, 1, 1},
	{1, 1, 0, 0, 1, 1, 0, 0}
},
{
	{1, 1, 0, 0, 1, 0, 1, 0},
	{1, 0, 1, 1, 0, 0, 0, 1}
},
{
	{1, 1, 0, 0, 1, 1, 0, 0},
	{0, 1, 1, 0, 0, 1, 1, 0}
},
{
	{1, 1, 0, 1, 1, 1, 1, 1},
	{0, 1, 1, 0, 1, 0, 0, 1}
},
{
	{0, 1, 1, 1, 0, 0, 0, 1},
	{1, 1, 1, 1, 0, 1, 0, 1}
},
{
	{0, 1, 1, 0, 0, 0, 0, 1},
	{1, 0, 1, 1, 0, 1, 0, 1}
},
{
	{1, 1, 1, 0, 1, 1, 1, 0},
	{0, 1, 1, 1, 1, 0, 1, 1}
},
{
	{0, 0, 1, 1, 1, 0, 0, 0},
	{0, 0, 1, 1, 1, 1, 1, 1}
},
{
	{1, 0, 1, 1, 0, 1, 0, 1},
	{0, 0, 1, 1, 1, 0, 0, 1}
},
{
	{0, 1, 0, 0, 1, 0, 1, 0},
	{0, 1, 0, 1, 0, 1, 0, 1}
},
{
	{1, 0, 0, 1, 0, 1, 1, 1},
	{0, 1, 0, 0, 1, 0, 0, 0}
},
{
	{1, 0, 0, 0, 0, 0, 0, 1},
	{0, 0, 0, 1, 0, 0, 1, 0}
},
{
	{0, 1, 1, 1, 0, 0, 1, 1},
	{0, 1, 0, 0, 0, 0, 0, 0}
},
{
	{0, 1, 0, 1, 1, 0, 0, 1},
	{1, 0, 1, 0, 0, 0, 0, 0}
},
{
	{0, 1, 0, 0, 0, 1, 1, 1},
	{1, 1, 1, 0, 1, 1, 1, 1}
},
{
	{0, 1, 1, 1, 1, 1, 0, 0},
	{0, 1, 0, 1, 1, 1, 0, 0}
},
{
	{0, 1, 0, 1, 1, 0, 1, 0},
	{0, 1, 1, 1, 0, 1, 0, 1}
},
{
	{1, 0, 0, 1, 1, 1, 1, 1},
	{1, 0, 1, 0, 1, 1, 1, 1}
},
{
	{0, 1, 1, 0, 1, 0, 1, 1},
	{0, 0, 0, 0, 0, 0, 0, 0}
},
{
	{0, 1, 0, 1, 1, 1, 0, 1},
	{0, 1, 1, 1, 0, 1, 1, 1}
},
{
	{0, 0, 0, 0, 0, 1, 1, 0},
	{1, 0, 0, 0, 1, 0, 0, 0}
},
{
	{0, 0, 0, 0, 0, 0, 0, 0},
	{1, 0, 0, 1, 0, 0, 0, 1}
},
{
	{1, 0, 1, 1, 0, 1, 0, 0},
	{1, 1, 1, 1, 1, 1, 0, 0}
},
{
	{1, 0, 1, 0, 0, 1, 1, 0},
	{0, 0, 0, 0, 0, 0, 1, 1}
},
{
	{0, 1, 0, 0, 0, 1, 1, 0},
	{0, 1, 1, 0, 1, 0, 1, 1}
},
{
	{1, 0, 1, 1, 0, 0, 1, 0},
	{0, 0, 0, 1, 0, 0, 1, 1}
},
{
	{0, 1, 0, 1, 0, 1, 1, 1},
	{1, 1, 1, 0, 1, 0, 0, 0}
},
{
	{0, 0, 1, 0, 1, 0, 0, 0},
	{1, 1, 1, 0, 1, 0, 0, 0}
},
{
	{1, 1, 1, 0, 1, 0, 1, 1},
	{1, 1, 1, 1, 0, 1, 1, 1}
},
{
	{0, 1, 0, 0, 0, 0, 1, 1},
	{1, 0, 0, 0, 1, 0, 0, 1}
},
{
	{1, 0, 1, 1, 1, 0, 0, 0},
	{1, 0, 1, 1, 0, 1, 1, 1}
},
{
	{1, 0, 0, 1, 1, 1, 0, 1},
	{0, 0, 1, 0, 1, 1, 0, 1}
},
{
	{1, 1, 1, 0, 0, 1, 0, 1},
	{1, 0, 0, 1, 0, 0, 1, 1}
},
{
	{1, 0, 1, 1, 1, 0, 0, 0},
	{0, 1, 0, 1, 1, 1, 1, 1}
},
{
	{0, 0, 0, 0, 0, 1, 0, 0},
	{0, 0, 0, 0, 1, 1, 0, 0}
},
{
	{1, 1, 0, 1, 0, 1, 1, 1},
	{0, 0, 0, 1, 1, 0, 1, 0}
},
{
	{1, 1, 1, 1, 1, 1, 0, 1},
	{1, 1, 0, 0, 1, 1, 0, 1}
},
{
	{0, 0, 1, 0, 0, 1, 1, 1},
	{1, 0, 1, 0, 0, 0, 1, 1}
}}
function get_spec(n)
  return specifications[(n % #specifications) + 1]
end
